/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IConnectionManager;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.applet.Applet;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class StdConnectionManager
implements IConnectionManager {
    private List<RemoteInstrument> m_instrList = new ArrayList<RemoteInstrument>();
    private Component m_uiParentComponent;

    public StdConnectionManager(Component component) {
        this.m_uiParentComponent = component;
    }

    public int getInstrumentCount() {
        int n = this.m_instrList.size();
        return n;
    }

    public synchronized RemoteInstrument getInstrument(int n) {
        if (n < 0 || n >= this.m_instrList.size()) {
            return null;
        }
        return this.m_instrList.get(n);
    }

    public synchronized RemoteInstrument getInstrument(String string) {
        for (RemoteInstrument remoteInstrument : this.m_instrList) {
            if (remoteInstrument.getConnection() == null || remoteInstrument.getConnection().getName().compareToIgnoreCase(string) != 0) continue;
            return remoteInstrument;
        }
        return null;
    }

    public synchronized void addInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrList.add(remoteInstrument);
    }

    public synchronized RemoteInstrument newConnection() {
        Object object;
        Object object2;
        String string = "";
        if (this.m_instrList.size() == 0 && (object2 = this.m_uiParentComponent instanceof JApplet ? (JApplet)this.m_uiParentComponent : (JApplet)SwingUtilities.getAncestorOfClass(JApplet.class, this.m_uiParentComponent)) != null) {
            try {
                object = ((Applet)object2).getCodeBase();
                string = ((URL)object).getHost();
            }
            catch (NullPointerException nullPointerException) {
                string = "";
            }
        }
        if (string.length() == 0) {
            string = QDUtil.getInstrumentIP(this.m_uiParentComponent);
        }
        if ((object2 = this.getInstrument(string)) == null) {
            object = new SocketConnection(string);
            object2 = new RemoteInstrument((IRemoteConnection)object, null);
            this.m_instrList.add((RemoteInstrument)object2);
        }
        return object2;
    }

    public RemoteInstrument getDefaultInstrument() {
        RemoteInstrument remoteInstrument = null;
        remoteInstrument = this.getInstrumentCount() == 0 ? this.newConnection() : this.getInstrument(0);
        if (!remoteInstrument.isConnected()) {
            try {
                remoteInstrument.connect();
            }
            catch (InstrumentException instrumentException) {
                return null;
            }
        }
        return remoteInstrument;
    }
}

